package com.handheld.UHFLongerDemo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

import android.app.Activity;
import android.content.Intent;
import android.content.SharedPreferences;
import android.graphics.Color;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.ListView;
import android.widget.SimpleAdapter;
import android.widget.Toast;

import com.handheld.UHFLonger.UHFLongerManager;
import com.handheld.apiinstructions.R;
import com.handheld.apiinstructions.Util;

public class UHFLongerActivity extends Activity implements OnClickListener{

	private static UHFLongerManager manager  ;
		
	private Button buttonClear;
	private Button buttonConnect;
	private Button buttonStart;
	private ListView listViewData;
	private Button buttonMore ;
	private ArrayList<EPC> listEPC;
	private ArrayList<Map<String, Object>> listMap;
	private boolean runFlag = true;
	private boolean startFlag = false;
	private boolean connectFlag = false;
	
	private MyApplication myAppli ;
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_uhfremote);
		myAppli = new MyApplication();
		MyApplication.myapp = myAppli;
		initView();
		Util.initSoundPool(this);//
		Thread thread = new InventoryThread();
		thread.start();
		
	}
	
	private void initView(){
		buttonStart = (Button) findViewById(R.id.button_start);
		buttonConnect = (Button) findViewById(R.id.button_connect);
		buttonClear = (Button) findViewById(R.id.button_clear);
		listViewData = (ListView) findViewById(R.id.listView_data);
		buttonMore = (Button) findViewById(R.id.button_more_operation);
		buttonMore.setOnClickListener(this);
		buttonStart.setOnClickListener(this);
		buttonConnect.setOnClickListener(this);
		buttonClear.setOnClickListener(this);
		setButtonClickable(buttonStart, false);
		setButtonClickable(buttonMore, false);
		listEPC = new ArrayList<EPC>();
		myAppli.setListEpc(new ArrayList<String>());
		
	}
	@Override
	protected void onPause() {
		startFlag = false;
		buttonStart.setText(getString(R.string.inventory));
		super.onPause();
	}
	
	@Override
	protected void onResume() {
		if(manager != null)
		manager.clearSelect();
		super.onResume();
	}
	
	@Override
	protected void onDestroy() {
		startFlag = false;
		runFlag = false;
		if(manager != null){
			manager.close();
		}
//		myAppli
		super.onDestroy();
	}
	
	private int count = 5 ;
	
	/**
	 * invertory thread 
	 * @author Administrator
	 *
	 */
	class InventoryThread extends Thread{
		private List<String> epcList;

		@Override
		public void run() {
			super.run();
			while(runFlag){
				
				if(startFlag ){
//					manager.stopInventoryMulti()
					epcList = manager.inventoryRealTime(); //
					if(epcList != null && !epcList.isEmpty()){
						//
						Util.play(1, 0);
						for(String epc:epcList){
//							String epcStr = new String(epc);
							addToList(listEPC, epc);
						}
					}
					epcList = null ;
					try {
						Thread.sleep(20);
					} catch (InterruptedException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}
				}
			}
		}
	}
	
	//EPC and to LISTVIEW
	private void addToList(final List<EPC> list, final String epc){
		runOnUiThread(new Runnable() {
			@Override
			public void run() {
				
				if(list.isEmpty()){
					EPC epcTag = new EPC();
					epcTag.setEpc(epc);
					epcTag.setCount(1);
					list.add(epcTag);
					myAppli.addEPC(epc);
				}else{
					for(int i = 0; i < list.size(); i++){
						EPC mEPC = list.get(i);
						if(epc.equals(mEPC.getEpc())){
						mEPC.setCount(mEPC.getCount() + 1);
						list.set(i, mEPC);
						break;
					}else if(i == (list.size() - 1)){
						EPC newEPC = new EPC();
						newEPC.setEpc(epc);
						newEPC.setCount(1);
						list.add(newEPC);
						//ӵapplication
						myAppli.addEPC(epc);
						}
					}
				}
				listMap = new ArrayList<Map<String,Object>>();
				int idcount = 1;
				for(EPC epcdata:list){
					Map<String, Object> map = new HashMap<String, Object>();
					map.put("ID", idcount);
					map.put("EPC", epcdata.getEpc());
					map.put("COUNT", epcdata.getCount());
					
					idcount++;
					listMap.add(map);
				}
				listViewData.setAdapter(new SimpleAdapter(UHFLongerActivity.this,
						listMap, R.layout.listview_item2, 
						new String[]{"ID", "EPC", "COUNT"}, 
						new int[]{R.id.textView_id, R.id.textView_epc, R.id.textView_count}));
			}
		});
	}
	
	private void setButtonClickable(Button button, boolean flag){
		button.setClickable(flag);
		if(flag){
			button.setTextColor(Color.BLACK);
		}else{
			button.setTextColor(Color.GRAY);
		}
	}
	
	/**
	 * clear listview
	 */
	private void clearData(){
		listEPC.removeAll(listEPC);
		listViewData.setAdapter(null);
		myAppli.getListEpc().removeAll(myAppli.getListEpc());
	}

	@Override
	public void onClick(View v) {
		switch (v.getId()) {
		case R.id.button_start:
//			startFlag = true ;
//			count = 5 ;
			if(!startFlag){
				startFlag = true ;
				buttonStart.setText(getString(R.string.stop_inventory));
			}else{
				startFlag = false;
				buttonStart.setText(getString(R.string.inventory));
			}
			break;
		case R.id.button_connect:
			try {
				manager = UHFLongerManager.getInstance();
				Timer timer = new Timer();
				timer.schedule(new TimerTask() {
					@Override
					public void run() {
						// TODO Auto-generated method stub
						SharedPreferences shared = getSharedPreferences("power", 0);
						final int value = shared.getInt("value", 30);
						if (manager.setOutPower((short) value)) {
							runOnUiThread( new Runnable() {
								public void run() {
									Toast.makeText(UHFLongerActivity.this, getString(R.string._power_now)+value, 0).show();
								}
							});
						}
					}
				}, 1000);
				
			} catch (Exception e) {
				
				e.printStackTrace();
			}
			if(manager == null){
				Toast.makeText(this, getString(R.string.serialport_init_fail), 0).show();
				setButtonClickable(buttonClear, false);
				setButtonClickable(buttonStart, false);
				setButtonClickable(buttonConnect, false);
				return ;
			}
			myAppli.setmanager(manager);
			Util.play(1, 0);
			setButtonClickable(buttonConnect, false);
			setButtonClickable(buttonStart, true);
			setButtonClickable(buttonMore, true);
			break;
		case R.id.button_more_operation:
			if(myAppli.getListEpc() == null || myAppli.getListEpc().isEmpty()){
				Toast.makeText(getApplicationContext(), getString(R.string._inventory_first), 0).show();
				return;
			}
			Intent intent = new Intent(UHFLongerActivity.this, MoreOperationActivity.class);
			startActivity(intent);
			break;
		case R.id.button_clear:
			clearData();
			break;
		default:
			break;
		}
	}
	
	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		getMenuInflater().inflate(R.menu.main, menu);
		
		return true;
	}
	@Override
	public boolean onMenuItemSelected(int featureId, MenuItem item) {
		// TODO Auto-generated method stub
		Intent intent = new Intent(this, SettingPower.class);
		startActivity(intent);
		
		return super.onMenuItemSelected(featureId, item);
	}
	public static UHFLongerManager getUhfmanager() {
		return manager;
	}
}
